# E0024: const/let/var with no bindings

`const`, `let`, or `var` statements need to declare at least one variable. It is
an error to declare nothing:

    var
    const friends = ["strager"];
    for (let  of friends) {
    }

To fix this error, add a variable name:

    var bestFriend;
    const friends = ["strager"];
    for (let friend of friends) {
      bestFriend = friend;
    }
