# E0015: expected expression before semicolon

`throw` statements require an expression following the `throw` keyword. It is an
error to rethrow an exception by writing just `throw;`:

    try {
      goNuts();
    } catch (e) {
      console.error(`couldn't handle deez nuts: ${e}`);
      throw;
    }

    function goNuts() {}

To rethrow an exception, name the exception variable after `throw`:

    try {
      goNuts();
    } catch (e) {
      console.error(`couldn't handle deez nuts: ${e}`);
      throw e;
    }

    function goNuts() {}

