# E0006: BigInt literal contains exponent

`BigInt` literals are number literals with an `n` suffix. These literals must
represent integers and cannot contain exponents (`e`).

    let atomDiameter = 1e-10n;
    let score = 1e2n;

To fix this error, make the number literal a `Number` literal by removing the
`n` suffix, or expand the exponent of the number:

    let atomDiameter = 1e-10;
    let score = 100n;
