# E0003: assignment to const variable

You cannot reassign variables declared with `const`. The assignment will crash
with a `ReferenceError` if you run the code.

    const pi = 3.14;
    pi = 6;

    const friends = ["Alice"];
    friends = ["Bob"];

To fix this error, assign to a different variable, declare a new variable with a
different name, or change `const` to `let`:

    let pi = 3.14;
    pi = 6;

    const friends = ["Alice"];
    const acquaintances = ["Bob"];
