# E0201: continue can only be used inside of a loop

```config-for-examples
{
  "globals": {
    "benchmarks": true
  }
}
```

A `continue` statement exit the current iteration of a `do`-`while` loop, `for`
loop, or `while` loop. It is a syntax error for a
`continue` statement to appear outside these loops:

    benchmarks.forEach(benchmark => {
      if (benchmark.shouldSkip) continue;
      benchmark.warmUp();
      if (benchmark.varianceTooHigh) continue;
      benchmark.run();
    });

To fix this error, write a `for`-`of` loop instead of using the `forEach` method:

    for (let benchmark of benchmarks) {
      if (benchmark.shouldSkip) continue;
      benchmark.warmUp();
      if (benchmark.varianceTooHigh) continue;
      benchmark.run();
    }

Alternatively, use `return` to exit the current iteration's function:

    benchmarks.forEach(benchmark => {
      if (benchmark.shouldSkip) return;
      benchmark.warmUp();
      if (benchmark.varianceTooHigh) return;
      benchmark.run();
    });

Alternatively, write an `if` statement to skip the undesired code:

    benchmarks.forEach(benchmark => {
      if (!benchmark.shouldSkip) {
        benchmark.warmUp();
        if (!benchmark.varianceTooHigh) {
          benchmark.run();
        }
      }
    });
