# E0195: missing parentheses around operand of `typeof`; `typeof` operator cannot be used before `**` without parentheses

```config-for-examples
{
  "globals": {
    "assert": true
  }
}
```

JavaScript does not allow unary operators left of a `**` expression. It is a
syntax error to write `delete`, `typeof`, or `void` before a `**` expression:

    assert(typeof 10 ** 7 === "number");

To fix this error, write parentheses around the `**` expression:

    assert(typeof (10 ** 7) === "number");

Introduced in quick-lint-js version 2.0.0.
