# E0191: event attributes must be camelCase

In HTML, attributes are case-insensitive; `onclick` is the same as `onClick` and
`ONCLICK`. In React, attributes are case-sensitive. It is a mistake for an event
attribute (starting with `on`) to be all lower-case:

    function TodoEntry({addTodo, changePendingTodo}) {
      return <form onsubmit={addTodo}>
        <input onchange={changePendingTodo} />
        <button>add todo</button>
      </form>;
    }

To fix this error, fix the capitalization by writing the attribute in
lowerCamelCase:

    function TodoEntry({addTodo, changePendingTodo}) {
      return <form onSubmit={addTodo}>
        <input onChange={changePendingTodo} />
        <button>add todo</button>
      </form>;
    }

Introduced in quick-lint-js version 2.0.0.
