# E0172: missing body for function

```config-for-examples
{
  "globals": {
    "numbers": true,
    "n": true
  }
}
```

Functions declared with `function` require a body, which must `{` `}`
surrounding a list of statements. It is a syntax error to omit the body of a
function:

    function isEven(n) return n % 2 === 0;

    for (let n of numbers) {
      if (isEven(n)) console.log(n);
    }

To fix this error, write `{` after the parameter list and `}` at the end of the
function's body:

    function isEven(n) { return n % 2 === 0; }

    for (let n of numbers) {
      if (isEven(n)) console.log(n);
    }
