# E0170: "global-groups" entries must be strings

In a [quick-lint-js configuration file][], items in the `"global-groups"` array
must be strings. It is an error if an item is an array, a boolean, a number, an
object, or `null`:

```quick-lint-js.config
{
    "global-groups": [
        "ecmascript",
        2020,
        "browser"
    ]
}
```

To fix this error, remove non-string items in `"global-groups"`:

```quick-lint-js.config
{
    "global-groups": [
        "ecmascript",
        "browser"
    ]
}
```

[quick-lint-js configuration file]: https://quick-lint-js.com/config/
