# E0159: unexpected literal in parameter list; expected parameter name

A function parameter can be a variable name, an array destructuring, or an
object destructuring. It is a syntax error for a function parameter list to
contain a number literal:

    function drop(array, count, 0) {
      return array.slice(count);
    }

To fix this error, make the literal a default value of a parameter:

    function drop(array, count = 0) {
      return array.slice(count);
    }

See also: E0151
