# E0143: unmatched '}'

```config-for-examples
{
  "globals": {
    "doWork": true,
    "work": true
  }
}
```

Every `{` introducing a code block must have a matching `}` ending a code block.
It is a syntax error to omit the `{`:

    function doAllWork() {
      while (work.length)
        doWork(work.pop());
      }
    }

To fix this error, write `{` to begin the code block:

    function doAllWork() {
      while (work.length) {
        doWork(work.pop());
      }
    }

Alternatively, remove the unnecessary `}`:

    function doAllWork() {
      while (work.length)
        doWork(work.pop());
    }
