# E0141: expected ')' to close function call

```config-for-examples
{
  "globals": {
    "iterationCount": true,
    "runBenchmarkIteration": true
  }
}
```

A function call requires a list of arguments surrounded by `(` and `)`. It is a
syntax error to omit the final `)` in a function call:

    for (let i = 0; i < iterationCount; ++i) {
      console.log("starting iteration", i, "...";
      runBenchmarkIteration();
      console.log("finished iteration", i);
    }

To fix this error, write the closing `)`:

    for (let i = 0; i < iterationCount; ++i) {
      console.log("starting iteration", i, "...");
      runBenchmarkIteration();
      console.log("finished iteration", i);
    }
