# E0140: expected expression after 'case'

A `switch` statement has a list of cases, each beginning with either the `case`
keyword or the `default` keyword. It is a syntax error to omit an expression
after the `case` keyword:

    function getText(node) {
      switch (node.nodeType) {
        case document.TEXT_NODE:
          return node.nodeValue;
        case: {
          let result = "";
          for (let child of node.childNodes) {
            result += getText(child, document);
          }
          return result;
        }
        default:
          throw new Error("Unsupported DOM node type");
      }
    }

    function colorToHexCode(color) {
      switch (color) {
        case 'red':   return '#ff0000';
        case 'green': return '#00ff00';
        case 'blue':  return '#0000ff';
        case:
          throw new Error(`unknown color ${color}`);
      }
    }

To fix this error, write an expression (usually a constant) after the `case`
keyword:

    function getText(node) {
      switch (node.nodeType) {
        case document.TEXT_NODE:
          return node.nodeValue;
        case document.ELEMENT_NODE: {
          let result = "";
          for (let child of node.childNodes) {
            result += getText(child, document);
          }
          return result;
        }
        default:
          throw new Error("Unsupported DOM node type");
      }
    }

Alternatively, replace the `case` keyword with `default` if the code should
execute if no other `case` would:

    function colorToHexCode(color) {
      switch (color) {
        case 'red':   return '#ff0000';
        case 'green': return '#00ff00';
        case 'blue':  return '#0000ff';
        default:
          throw new Error(`unknown color ${color}`);
      }
    }
