# E0132: missing ',' between variable declarations

```config-for-examples
{
  "globals": {
    "p": true,
    "pi": true
  }
}
```

A `const`, `let`, and `var` statement can declare multiple variables. It is a
syntax error to omit a `,` between declared variables:

    const x=p.x y=p.y;

    let tau = 2 pi;

Fix this this error, write a `,` before the second variable's name:

    const x=p.x, y=p.y;

Alternatively, use the `*` operator to multiply a variable by a number:

    let tau = 2*pi;
