# E0127: TypeScript's 'enum' feature is not yet implemented by quick-lint-js

```config-for-examples
{
  "globals": {
    "Color": true,
    "BLUE": true,
    "GREEN": true,
    "RED": true
  }
}
```

JavaScript does not support TypeScript-style enums. It is a syntax error to
declare an enum:

```javascript-ignoring-extra-errors
enum Color {
  BLUE,
  GREEN,
  RED,
}

const favoriteColor = Color.BLUE;
```

To fix this error, write an object instead:

    const Color = {
      BLUE: 0,
      GREEN: 1,
      RED: 2,
    };

    const favoriteColor = Color.BLUE;

Alternatively, declare separate variables:

    const Color_BLUE = 0;
    const Color_GREEN = 1;
    const Color_RED = 2;

    const favoriteColor = Color_BLUE;
