# E0098: for loop needs an iterable, or condition and update clauses

```config-for-examples
{
  "globals": {
    "collidedEntities": true,
    "damage": true
  }
}
```


There are three kinds of `for` loops: C-style `for` loops (`;`), `for`-`in`
loops, and `for`-`of` loops. It is a syntax error to write a `for` loop without
`;`, `in`, or `of`:

    for (const enemy) {
      enemy.health -= damage;
    }

    for (let i) {
      console.log(i % 15 ? i : "FizzBuzz");
    }

To fix this error, write `in` or `of` followed by an iterable (such as an
array):

    for (const enemy of collidedEntities) {
      enemy.health -= damage;
    }

Alternatively, write the remainder of the C-style `for` loop:

    for (let i = 0; i < 100; ++i) {
      console.log(i % 15 ? i : "FizzBuzz");
    }
