# E0091: switch statement needs parentheses around condition

`switch` statements have a condition after the `switch` keyword. It is a syntax
error to write a condition without `(` and `)`:

    function colorToHexCode(color) {
      switch color {
        case 'red':   return '#ff0000';
        case 'green': return '#00ff00';
        case 'blue':  return '#0000ff';
      }
    }

To fix this error, write `(` before the condition and `)` after the condition:

    function colorToHexCode(color) {
      switch (color) {
        case 'red':   return '#ff0000';
        case 'green': return '#00ff00';
        case 'blue':  return '#0000ff';
      }
    }
