# E0080: missing name of class

If a statement begins with the `class` keyword, the declared class must have a
name. It is a syntax error to start a statement with `class` but not give a name
to the class:

    class {
      speak() {
        console.log('woof!');
      }
    }

To fix this error, write the name of the class after the `class` keyword:

    class Doggie {
      speak() {
        console.log('woof!');
      }
    }

Alternatively, declare a variable and initialize it with the class:

    const Doggie = class {
      speak() {
        console.log('woof!');
      }
    };
