# E0059: assignment to undeclared variable

```config-for-examples
{
  "globals": {
    "isHappy": true
  }
}
```

It is an error to assign to a variable without declaring it:

    tau = Math.pi * 2;

    let emotion;
    if (isHappy) {
      emotion = "happy";
    } else {
      emotio = "sad";
    }
    console.log("I am " + emotion);

To fix this error, declare the variable using `const` or `let`:

    let emotion;
    if (isHappy) {
      emotion = "happy";
    } else {
      emotion = "sad";
    }
    console.log("I am " + emotion);

Alternatively, if the variable is global in your environment, [write a
quick-lint-js.config file](https://quick-lint-js.com/config/).
