# E0052: unexpected '#'

```config-for-examples
{
  "globals": {
    "encrypt": true,
    "sendMessage": true,

    "synchronous": true,
    "blocking": true
  }
}
```

In JavaScript, `#` is used for private properties and for shebangs at the
beginning of a file (e.g. `#!/usr/bin/env node`). (`#` does not start a
comment.) It is an error to use `#` anywhere else:

    class Auth {
      #password;

      authenticate() {
        # synchronous (blocking)
        sendMessage(encrypt(this.# password));
      }
    }

To fix this error, write the property's name after `#`, and use `//` for line
comments:

    class Auth {
      #password;

      authenticate() {
        // synchronous (blocking)
        sendMessage(encrypt(this.#password));
      }
    }
