# E0037: unclosed block comment

```config-for-examples
{
  "globals": {
    "heightInCM": true
  }
}
```

Block comments start with `/*` and end with `*/`. It is a syntax error for a
block comment to start but not end:

```javascript-with-errors
/* this code is really complicated.
   some might say too complicated.
function yes() {
  return true;
}
```

```javascript-with-errors
let heightInFeet = heightInCM /* 100;
```

To fix this error, close the comment with `*/`.

    /* this code is really complicated.
       some might say too complicated. */
    function yes() {
      return true;
    }

Alternatively, write an expression between `/` and `*`:

    let heightInFeet = heightInCM / 3.28 * 100;
