# E0032: legacy octal literal may not be BigInt

Decimal number literals can be `BigInt` with an `n` suffix. Legacy octal number
literals, which start with an extra `0` digit, cannot be suffixed with `n`:

    const ID = 012127638745381751821n;
    const perms = 07750775077507750775n;

To fix this error, make the number literal a decimal number literal by removing
the extra leading `0`, or use the `0o` to make the a modern octal literal:

    const ID = 1234567890123456789n;
    const perms = 0o0775_0775_0775_0775_0775n;
