# E0021: invalid lone literal in object literal

An object literal entry must either be a `key: value` pair, a method, or
variable short-hand. It is an error to use the short-hand syntax with anything
except a variable name:

    // A tasty enum
    const FRUITS = {
      "BANANA",
      "ORANGE",
      "STRAWBERRY",
      "KIWI",
    };

    // Pre-computed for speed
    let smallPrimes = {2, 3, 5, 7, 11, 13, 17, 19};

To fix this error, either use the `key: value` pair syntax, or use `[` `]` to
create an array literal instead of an object literal:

    // A tasty enum
    const FRUITS = {
      BANANA: "BANANA",
      ORANGE: "ORANGE",
      STRAWBERRY: "STRAWBERRY",
      KIWI: "KIWI",
    };

    // Pre-computed for speed
    let smallPrimes = [2, 3, 5, 7, 11, 13, 17, 19];
