# E0020: invalid expression left of assignment

```config-for-examples
{
  "globals": {
    "steps": true,
    "doStep": true,
    "stopNumber": true
  }
}
```

In JavaScript, you can assign to variables or properties. It is a syntax error
to assign to something different, such as the result of a function call or the
result of math:

    function saveAccount(account, {name, pass}) {
      account.checkPassword(pass);
      account.getName() = name;
      account.getPassword() = pass;
      account.save();
    }

    for (let step of steps) {
      if (step.index+1 = stopNumber) {
        break;
      }
      doStep(step);
    }

To fix this error, assign to a variable or property instead, or call a method to
do the assignment:

    function saveAccount(account, {name, pass}) {
      account.checkPassword(pass);
      account.name = name;
      account.changePassword(pass);
      account.save();
    }

Alternatively, write `==` or `===` instead of `=`, changing the assignment into
a comparison:

    for (let step of steps) {
      if (step.index+1 === stopNumber) {
        break;
      }
      doStep(step);
    }
