# E0009: cannot export variable named 'let'

An exported function cannot be named `let`:

    export function let() {
      console.log("access permitted");
    }

To fix this error, name the function something other than `let`, or declare the
function separately with a different name and use `export`-`as`:

    export function allow() {
      console.log("access permitted");
    }

    function allowAccess() {
      console.log("access permitted");
    }
    export { allowAccess as let };
