# E0001: variable assigned before its declaration

Variables declared with `let` can only be reassigned by code below the
declaration. The assignment will crash with a `ReferenceError` if you assign to
the variable.

    function getNumberOfChocolates() { return 3; }
    let shouldEatChocolates = true;

    if (shouldEatChocolates) {
      chocolates = 0;
    }
    let chocolates = getNumberOfChocolates();

To fix this error, move the declaration above the assignment:

    function getNumberOfChocolates() { return 3; }
    let shouldEatChocolates = true;

    let chocolates = getNumberOfChocolates();
    if (shouldEatChocolates) {
      chocolates = 0;
    }
