# E0208: cannot access private identifier outside class

The following code is accessing a private identifier outside
the class.

    class C {
      #x = 10;
    }

    function f(c) {
      c.#x = 20;
    }

To fix this error, move function `f` as a static member of
class `C` .

    class C {
      #x = 10;
      static f(c) {
        c.#x = 20;
      }
    }

Another way to fix this error, remove `#` before variable
`x`.

    class C {
      x = 10;
    }

    function f(c) {
      c.x = 20;
    }
