# E0207: code point in Unicode escape sequence must not be greater than U+10FFFF

Identifiers, string literals, and template literals can contain Unicode escape
sequences starting with `\u`. It is a syntax error for a Unicode escape sequence
to refer to a character which is beyond the range of valid Unicode code points
(U+0000 to U+10FFFF):

    class ChirpSound {}
    let bird\u{360000} = new ChirpSound();

    let x = "hello\u{abcdef}";

To fix this error, make sure that the escaped code point is
between U+0000 and U+10FFFF inclusive.

    class ChirpSound {}
    let bird\u{3600} = new ChirpSound();

    let x = "hello\u{abcde}";
