# E0200: break can only be used inside of a loop or switch

```config-for-examples
{
  "globals": {
    "hand": true,
    "friends": true
  }
}
```

A `break` statement exits a `do`-`while` loop, `for` loop, `while` loop, or
`switch` statement. It is a syntax error for a `break` statement to appear
outside these loops or a `switch` statement:

    friends.forEach((friend) => {
      hand.giveHighFive(friend);
      if (hand.isTired) {
        break;
      }
    });

To fix this error, write a `for`-`of` loop instead of using the `forEach`
method:

    for (const friend of friends) {
      hand.giveHighFive(friend);
      if (hand.isTired) {
        break;
      }
    }
