# E0190: missing comparison; '===' does not extend to the right side of '||'

In English, we might say “if the selection is ‘agree’ or ‘strongly agree’,
return a rating of 1”. If this English phrase is translated naïvely into
JavaScript, the code will behave as if every selection has a rating of 1:

    function getRating(radioElement) {
      let selection = radioElement.value;
      if (selection === "agree" || "strongly agree") {
        return 1;
      } else if (selection === "disagree") {
        return 0;
      } else if (selection === "strongly disagree") {
        return -1;
      }
    }

This happens because `if (selection === "agree" || "strongly agree")` is
interpreted as `if ((selection === "agree") || "strongly agree")`, i.e. “if
selection is ‘agree’, or if ‘strongly agree’ is truthy, then …”. Because the
string `"strongly agree"` is not empty, it is truthy, and the condition is
always true.

To fix this error, write the `==` or `===` comparison on both sides of `||`:

    function getRating(radioElement) {
      let selection = radioElement.value;
      if (selection === "agree" ||
          selection === "strongly agree") {
        return 1;
      } else if (selection === "disagree") {
        return 0;
      } else if (selection === "strongly disagree") {
        return -1;
      }
    }

Introduced in quick-lint-js version 2.0.0.
