# E0186: missing '...' in JSX attribute spread

In a JSX tag, you can use an object as a source of attributes. It is a syntax
error to omit the `...` before the object:

    function Link({text, ...props}) {
      return <a {props}>{text}</a>;
    }

To fix this error, write `...` after `{` in the spread attribute:

    function Link({text, ...props}) {
      return <a {...props}>{text}</a>;
    }

Introduced in quick-lint-js version 2.0.0.
