# E0181: unclosed string literal

JSX attribute values can be strings. These strings need to be closed with either
`"` or `'` (whichever was used to start the string). It is a syntax error to
omit `"` or `'`:

```javascript-ignoring-extra-errors
function NavLink({href, children}) {
  return <li><a href={href} className="nav-link>{children}</a></li>;
}
```

To fix this error, end the string by writing the matching `"` or `'`:

    function NavLink({href, children}) {
      return <li><a href={href} className="nav-link">{children}</a></li>;
    }

Introduced in quick-lint-js version 2.0.0.
