# E0176: missing arrow operator for arrow function

Arrow functions have a parameter list followed by `=>` followed by a function
body. It is a syntax error to omit the `=>`:

    let fs = require("fs");
    fs.readFile(process.argv[2], (err, data) {
      console.log(data);
    });

To fix this error, write `=>` after the parameter list:

    let fs = require("fs");
    fs.readFile(process.argv[2], (err, data) => {
      console.log(data);
    });

Alternatively, write `function` before the parameter list:

    let fs = require("fs");
    fs.readFile(process.argv[2], function(err, data) {
      console.log(data);
    });
