# E0174: functions/methods should not have '=>'

```config-for-examples
{
  "globals": {
    "axios": true,
    "url": true
  }
}
```

Classes and object literals can contain methods. It is a syntax error to write
`=>` before the method's body:

    class Dog {
      bark() => {
        console.log("woof");
      }
    }

    class Downloader {
      okStatuses = [200];

      async download(url) {
        return await axios.get(url, {
          responseType: "json",
          validateStatus(status) => {
            return this.okStatuses.includes(status);
          },
        });
      }
    }

To fix this error, remove the `=>` to create a valid method:

    class Dog {
      bark() {
        console.log("woof");
      }
    }

Alternatively, in an object literal, create an arrow function instead of a
method by adding `:` after the method name:

    class Downloader {
      okStatuses = [200];

      async download(url) {
        return await axios.get(url, {
          responseType: "json",
          validateStatus: (status) => {
            return this.okStatuses.includes(status);
          },
        });
      }
    }
