# E0149: missing body for statement; a class statement is not allowed as the body of statement

```config-for-examples
{
  "globals": {
    "config": true
  }
}
```

`do`-`while` loops, `if` statements, `for` loops, `while` loops, and `with`
statements require a statement or list of statements for the body. It is a
syntax error to write a class as the body of such a statement:

    let flavors = [];
    for (let flavor in config.sweets)

    class SweetsBasket { /* ... */ }

To fix this error, write the body of the `do`-`while` loop, `if` statements,
   `for` loop, `while` loop, or `with` statement:

    let flavors = [];
    for (let flavorName in config.sweets) {
      flavors.push(flavorName);
    }

    class SweetsBasket { /* ... */ }
