# E0146: missing ':' in conditional expression

```config-for-examples
{
  "globals": {
    "focus": true
  }
}
```

The `? :` ternary operator has three parts: the condition, the expression if
true, and the expression if false. It is a syntax error to omit the expression
if false:

    for (let i = 1; i <= 100; ++i) {
      console.log(i % 15 ? i);
    }

    document.querySelector("form input")?focus();

To fix this error, write `:` followed by an expression:

    for (let i = 1; i <= 100; ++i) {
      console.log(i % 15 ? i : "FizzBuzz");
    }

Alternatively, write `?.` instead of `?` to access an object's property:

    document.querySelector("form input")?.focus();
