# E0134: unclosed code block; expected '}' by end of file

```config-for-examples
{
  "globals": {
    "doWork": true,
    "work": true
  }
}
```

Every `{` introducing a code block must have a matching `}` ending a code block.
It is a syntax error to omit the `}`:

    function doAllWork() {
      while (work.length) {
        doWork(work.pop());
    }

To fix this error, write a matching `}`:

    function doAllWork() {
      while (work.length) {
        doWork(work.pop());
      }
    }

Alternatively, remove an unnecessary `{`:

    function doAllWork() {
      while (work.length)
        doWork(work.pop());
    }
