# E0123: missing variable name

```config-for-examples
{
  "globals": {
    "bananas": true,
    "getBananas": true
  }
}
```

You can declare a variable with `const`, `let`, or `var`. It is a syntax error
to use `const`, `let` (in some cases), or `var` without mentioning a variable
name:

    const = getBananas();
    console.log(bananas[0].peel());

    for (let i,= 1; i < 100; ++i) {
      console.log(i % 15 ? i : "FizzBuzz");
    }

To fix this error, write a variable name:

    const banans = getBananas();
    console.log(bananas[0].peel());

Alternatively, remove the extra `,`:

    for (let i = 1; i < 100; ++i) {
      console.log(i % 15 ? i : "FizzBuzz");
    }
