# E0090: with statement is missing '(' or ')' around expression

```config-for-examples
{
  "globals": {
    "person": true
  }
}
```

`with` statements have an expression after the `with` keyword. It is a syntax
error to write an expression without either `(` or `)`:

    with (person {
      console.log(`Hi, ${firstName} ${lastName}!`);
    }

To fix this error, write `(` before the expression or `)` after the expression:

    with (person) {
      console.log(`Hi, ${firstName} ${lastName}!`);
    }
