# E0081: missing name of exported class

```config-for-examples
{
  "globals": {
    "React": true
  }
}
```

In modules, classes can be exported by name or by default. It is an error to
export an unnamed class by name:

    export class {
      render() {
        return React.createElement(
          "h1",
          null,
          `Hello, ${this.props.name}!`,
        );
      }
    }

To fix this error, export the class by default:

    // Import using:
    // import MyComponent from "./MyComponent.mjs";
    export default class {
      render() {
        return React.createElement(
          "h1",
          null,
          `Hello, ${this.props.name}!`,
        );
      }
    }

Alternatively, give a name to the class:

    // Import using:
    // import {MyComponent} from "./MyComponent.mjs";
    export class MyComponent {
      render() {
        return React.createElement(
          "h1",
          null,
          `Hello, ${this.props.name}!`,
        );
      }
    }
