# E0075: indexing requires an expression

```config-for-examples
{
  "globals": {
    "friends": true
  }
}
```

The syntax for indexing is `expr1[expr2]`. It is an error to omit the expression
between `[` and `]`:

    let colorToCode = {
      red:   '#ff0000',
      green: '#00ff00',
      blue:  '#0000ff',
    };
    let color = prompt();
    document.body.style.color = colorToCode[];

    let newFriends = friends[];
    newFriends.push("Alice");
    console.log(friends, "=>", newFriends);

To fix this error, write an expression between `[` and `]`:

    let colorToCode = {
      red:   '#ff0000',
      green: '#00ff00',
      blue:  '#0000ff',
    };
    let color = prompt();
    document.body.style.color = colorToCode[color];

Alternatively, to copy an array, create a new array and spread the old array
into the new array:

    let newFriends = [...friends];
    newFriends.push("Alice");
    console.log(friends, "=>", newFriends);
