# E0071: cannot declare 'yield' inside generator function

In non-strict mode, a variable can be named `yield`. In strict mode and inside
generator functions, it is a syntax error to use `yield` as a variable name:

```javascript-ignoring-extra-errors
function *mapRange(end, f) {
  for (let i = 0; i < end; ++i) {
    const
    yield item;
  }
}
```

To fix this error, complete the variable declaration preceeding `yield`:

    function *mapRange(f, end) {
      for (let i = 0; i < end; ++i) {
        const item = f(i);
        yield item;
      }
    }
