# E0068: extra ',' is not allowed between function call arguments

In a function call, an extra `,` can be added to the end of the argument list.
However, it is a syntax error to include an extra `,` in between arguments:

    let name = prompt();
    console.log("Hello",, name);

To fix this error, remove the extra `,`:

    let name = prompt();
    console.log("Hello", name);

Alternatively, write an argument between the two `,`s:

    let honorific = prompt();
    let name = prompt();
    console.log("Hello", honorific, name);
