# E0066: exporting requires '{' and '}'

When exporting a class, function, or variable, you must either export while
declaring or export separately from declaring. When exporting separately, it is
a syntax error to write `export` followed by the name of the thing you want to
export:

    class Person {}

    export Person;

To fix this error, add `{` and `}` around the exported names:

    class Person {}

    export {Person};

Alternatively, write the `default` keyword after `export`:

    class Person {}

    export default Person;
