# E0064: missing body for 'if' statement

```config-for-examples
{
  "globals": {
    "AssertionError": true,
    "rose": true,
    "sugar": true,
    "violet": true
  }
}
```

`if` statements require a body, which must be a statement or `{` `}` surrounding
a list of statements. It is a syntax error to omit the body of an `if`
statement:

    function assert(condition) {
      if (!condition)
    }

    if (rose.color === 'red' &&
        violet.color === 'blue')

To fix this error, write the body of the `if` statement:

    function assert(condition) {
      if (!condition)
        throw new AssertionError();
    }

    if (rose.color === 'red' &&
        violet.color === 'blue') {
      sugar.flavor = 'sweet';
    }
