# E0043: unexpected '\\' in identifier

```config-for-examples
{
  "globals": {
    "ChirpSound": true
  }
}
```

Identifiers (variable names, etc.) can contain Unicode escape sequences
(`\u{69}` for example). It is an error for an identifier to have a backslash
which is not part of a Unicode escape sequence:

    function identity\(x) { return x; }

    let bird\U3600 = new ChirpSound();

To fix this error, remove the backslash, or complete the Unicode escape
sequence:

    function identity(x) { return x; }

    let bird\u3600 = new ChirpSound();
