# E0040: unclosed string literal

String literals start with `"` or `'` and end with `"` or `'`, respectively.
It is a syntax error to omit the trailing `"` or `'` from a string literal. A
missing terminator can happen for a number of reasons:

    // The final " is escaped by \.
    let temp = "c:\temp\";

    // String literals cannot span multiple lines.
    // Poem by Ian Johnson.
    let poem = "My code fails. I do not know why.
    My code works. I do not know why.";

    let unfinishedThought = "The solution is

To fix this error, ensure a backslash (`\`) is not escaping the terminator,
use a template literal for multi-line strings, or just include a terminator:

    let temp = "c:\\temp\\";

    // Poem by Ian Johnson.
    let poem = `My code fails. I do not know why.
    My code works. I do not know why.`;

    let unfinishedThought = "The solution is";
