# E0039: unclosed regexp literal

Regular expression literals start with `/` and end with `/`. The `/` symbol is
also used for the division operator. It is a syntax error to omit the trailing
`/` from a regular expression literal:

    // The final / is escaped by \.
    let LINE_CONTINUATION_RE = / +\/m;

    function feetToCentimeters(feet) {
        // The / is interpreted as the start of a
        // regular expression, not the division
        // operator.
        return / 3.28 * 100;
    }

To fix this error, close the regular expression literal:

    let LINE_CONTINUATION_RE = / +\\/m;

Alternatively, include an expression before `/` to treat the `/` as a division
operator:

    function feetToCentimeters(feet) {
        return feet / 3.28 * 100;
    }
