# E0035: RegExp literal flags cannot contain Unicode escapes

```config-for-examples
{
  "globals": {
    "headerName": true
  }
}
```

Regular expression literals can contain flags. These flags must not be escaped
using a Unicode escape sequence:

    const isContentLength =
      /content-length/\u{69}.test(headerName);

To fix this error, stop being clever; write the flag letter directly:

    const isContentLength =
      /content-length/i.test(headerName);
