# E0023: keywords cannot contain escape sequences

Outside a string or template literal, Unicode escape sequences (like `\u{65}`)
can be used in identifiers. However, Unicode escape sequences are not allowed if
they would make an identifier look like a keyword when unescaped:

    let \u{69}\u{66} = "if";
    let which = \u{66}inally;

To fix this error, either pick a different variable name, or make a string:

    let _\u{69}\u{66} = "if";
    let which = "\u{66}inally";
